/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.result;

import com.floragunn.signals.settings.SignalsSettings;
import com.floragunn.signals.watch.result.WatchLog;
import com.floragunn.signals.watch.result.WatchLogWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class WatchLogIndexWriter
implements WatchLogWriter {
    private static final Logger log = LogManager.getLogger(WatchLogIndexWriter.class);
    private final Client client;
    private final String tenant;
    private final SignalsSettings settings;
    private final ToXContent.Params toXparams;
    private final WriteRequest.RefreshPolicy refreshPolicy;
    private final boolean syncIndexing;

    public WatchLogIndexWriter(Client client, String tenant, SignalsSettings settings, ToXContent.Params toXparams) {
        this.client = client;
        this.tenant = tenant;
        this.settings = settings;
        this.toXparams = toXparams;
        this.refreshPolicy = settings.getStaticSettings().getWatchLogRefreshPolicy();
        this.syncIndexing = settings.getStaticSettings().isWatchLogSyncIndexingEnabled();
    }

    @Override
    public void put(final WatchLog watchLog) {
        String indexName = this.settings.getDynamicSettings().getWatchLogIndex();
        IndexRequest indexRequest = new IndexRequest(indexName);
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        try (XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
             ThreadContext.StoredContext storedContext = threadContext.stashContext();){
            if (watchLog.getTenant() == null) {
                watchLog.setTenant(this.tenant);
            }
            if (log.isDebugEnabled()) {
                log.debug("Going to write WatchLog " + (this.refreshPolicy == WriteRequest.RefreshPolicy.IMMEDIATE ? " (immediate) " : "") + watchLog);
            }
            threadContext.putHeader("_sg_internal_auth_token", null);
            threadContext.putHeader("_sg_internal_auth_token_audience", null);
            watchLog.toXContent(jsonBuilder, this.toXparams);
            indexRequest.source(jsonBuilder);
            indexRequest.setRefreshPolicy(this.refreshPolicy);
            if (this.syncIndexing) {
                IndexResponse response = (IndexResponse)this.client.index(indexRequest).actionGet();
                if (log.isDebugEnabled()) {
                    log.debug("Completed sync writing WatchLog: " + watchLog + "\n" + Strings.toString((ToXContent)response));
                }
            } else {
                this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                    public void onResponse(IndexResponse response) {
                        if (log.isDebugEnabled()) {
                            log.debug("Completed writing WatchLog: " + watchLog + "\n" + Strings.toString((ToXContent)response));
                        }
                    }

                    public void onFailure(Exception e) {
                        log.error("Error while writing WatchLog " + watchLog, (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Error while writing WatchLog " + watchLog, (Throwable)e);
        }
    }

    public static WatchLogIndexWriter forTenant(Client client, String tenantName, SignalsSettings settings, ToXContent.Params toXparams) {
        return new WatchLogIndexWriter(client, tenantName, settings, toXparams);
    }
}

